﻿# Mastering Node.js - Second Edition
This is the code repository for [Mastering Node.js - Second Edition](https://www.packtpub.com/web-development/mastering-nodejs-second-edition?utm), published by [Packt](https://www.packtpub.com/?utm). It contains all the supporting project files necessary to work through the book from start to finish.
## About the Book
Node.js with its strong features and ability to write server as well as client-side code with JavaScript has become a popular choice amongst developers for building powerful web applications.

This book is a deep dive into showing facets of Node which are helpful for creating highly concurrent and scalable real-time applications. It takes you through a concise yet thorough tour of Node's innovative event non-blocking design, showing you how to build professional applications with the help of detailed examples. This edition is updated to incorporate the Node 9 changes. A large, general change is that the code will be modernized to the ES6 patterns available in Node 9. This involves rewriting the code examples themselves and introducing Promises, functional programming, Maps and Sets and other new patterns for writing JavaScript code in Node. We will be also covering Microservices to simplify the design and composition of distributed systems. we will learn how using small, independent “agents” communicating through simple protocols can be organized into dynamic, resilient, and understandable application architectures.

Mastering Node.js contains all of the examples and explanations you’ll need to build applications in a short amount of time and at a low cost, running on a scale and speed that would have been nearly impossible just a few years ago.

## Instructions and Navigation
All of the code is organized into folders. Each folder starts with a number followed by the application name. For example, Chapter02.



The code will look like the following:
```
const s1 = "first string";
const s2 = "second string";
let s3 = s1 + s2;
```

You will need to have some familiarity with JavaScript, and have a copy of Node installed on your development machine or server, Version 9.0 or higher. You should know how to install programs on this machine, as you will need to install Redis, along with other libraries like Docker. Having Git installed will greatly improve your experience.

You should install RabbitMQ so that you can follow with the examples using message queues. The sections on using NGINX to proxy Node servers will, of course, require that you can install and use that web server. To build C++ add-ons, you will need to install the appropriate compiler on your system.

The examples in this book are built and tested within UNIX-based environments (including Mac OS X), but you should be able to run all Node examples on Windows-based operating systems as well. You can obtain installers for your system, and binaries, from http://www.nodejs.org.

## Related Products
* [Mastering Node.js](https://www.packtpub.com/web-development/mastering-nodejs?utm/sitory&utm_campaign=9781782166320)

* [Advanced Server-Side Programming with Node.js [Video]](https://www.packtpub.com/web-development/advanced-server-side-programming-nodejs-video?utm)

* [Server-side Programming with Node.js for Beginners [Video]](https://www.packtpub.com/business/server-side-programming-nodejs-beginners-video?utm)
